class Level_Skilled expands Mutator config(MonsterMatch);

var config int MaxMonsters;
var bool Initialized, bGameEnded;
var int NumPoints, NavPoint, delay, TotalMonsters;


function PreBeginPlay ()
{
	Super.PreBeginPlay();
	SaveConfig();

	SetTimer(1.0,True);

	AddMutator(Level.Spawn(class'Stats_Skilled'));
}

function PostBeginPlay()
{
local NavigationPoint NP;

	if (Initialized)
		{
		return;
		}
	Initialized = True;

	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if (NP.IsA('PathNode'))
			{
			NumPoints++;
			}
		}
}

function bool HandleEndGame()
{
	Super.HandleEndGame();

	bGameEnded = True;

	if (NextMutator != None)
		return (NextMutator.HandleEndGame());
}

function Timer()
{
local Pawn P;
local int NumMonsters;
local MonsterPRI MPRI;

	if ( bGameEnded )
		return;

	if ( Delay <= 0 )
		{
		if ( TotalMonsters < MaxMonsters )
			{
			SpawnMonster();
			}
		Delay = 3;
		}
	else
		Delay--;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('Monsters'))
			{
			NumMonsters++;
			}
		}

	TotalMonsters = NumMonsters;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			MPRI = MonsterPRI(PlayerPawn(P).PlayerReplicationInfo);
			MPRI.NumMonsters = NumMonsters;
			MPRI.Level = "Skilled";
			}
		}
}

function SpawnMonster()
{
local int PointCount;
local int Dice;

	Dice = Rand(100);

	if ( Dice < 15 )		//15%
		SpawnKralies();
	else if ( Dice < 25 )		//10%
		SpawnPupies();
	else if ( Dice < 35 )		//10%
		SpawnFlyers();
	else if ( Dice < 50 )		//15%
		SpawnBruties();
	else if ( Dice < 60 )		//10%
		SpawnSnakes();
	else if ( Dice < 70 )		//10%
		SpawnManties();
	else if ( Dice < 80 )		//10%
		SpawnGassies();
	else if ( Dice < 90 )		//10%
		SpawnSkaarjies();
	else				//10%
		SpawnMercs();
}

function SpawnSkaarjies()
{
local NavigationPoint NP;
local RazorSkaarji SkaarjiA;
local PlasmaSkaarji SkaarjiB;
local EliteSkaarji SkaarjiC;
local SniperSkaark SkaarjiD;
local FlakSkaark SkaarjiE;
local ShockSkaark SkaarjiF;
local PlasmaSkaark SkaarjiG;
local ShredderSkaark SkaarjiH;
local RocketSkaark SkaarjiI;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 15 )
					{
					SkaarjiA = Spawn(Class'RazorSkaarji', , , NP.Location);
					if ( SkaarjiA != None )
						SkaarjiA.GotoState('Attacking');
					}
				else if ( Dice < 30 )
					{
					SkaarjiB = Spawn(Class'PlasmaSkaarji', , , NP.Location);
					if ( SkaarjiB != None )
						SkaarjiB.GotoState('Attacking');
					}
				else if ( Dice < 45 )
					{
					SkaarjiC = Spawn(Class'EliteSkaarji', , , NP.Location);
					if ( SkaarjiC != None )
						SkaarjiC.GotoState('Attacking');
					}
				else if ( Dice < 60 )
					{
					SkaarjiD = Spawn(Class'SniperSkaark', , , NP.Location);
					if ( SkaarjiD != None )
						{
						SkaarjiD.GotoState('Attacking');
						DeathMatchPlus(Level.Game).GiveWeapon(SkaarjiD,"BotPack.SniperRifle");
						}
					}
				else if ( Dice < 65 )
					{
					SkaarjiE = Spawn(Class'FlakSkaark', , , NP.Location);
					if ( SkaarjiE != None )
						{
						SkaarjiE.GotoState('Attacking');
						DeathMatchPlus(Level.Game).GiveWeapon(SkaarjiE,"BotPack.UT_FlakCannon");
						}
					}
				else if ( Dice < 75 )
					{
					SkaarjiF = Spawn(Class'ShockSkaark', , , NP.Location);
					if ( SkaarjiF != None )
						{
						SkaarjiF.GotoState('Attacking');
						DeathMatchPlus(Level.Game).GiveWeapon(SkaarjiF,"BotPack.ShockRifle");
						}
					}
				else if ( Dice < 85 )
					{
					SkaarjiG = Spawn(Class'PlasmaSkaark', , , NP.Location);
					if ( SkaarjiG != None )
						{
						SkaarjiG.GotoState('Attacking');
						DeathMatchPlus(Level.Game).GiveWeapon(SkaarjiG,"BotPack.PulseGun");
						}
					}
				else if ( Dice < 95 )
					{
					SkaarjiH = Spawn(Class'ShredderSkaark', , , NP.Location);
					if ( SkaarjiH != None )
						{
						SkaarjiH.GotoState('Attacking');
						DeathMatchPlus(Level.Game).GiveWeapon(SkaarjiH,"BotPack.minigun2");
						}
					}
				else
					{
					SkaarjiI = Spawn(Class'RocketSkaark', , , NP.Location);
					if ( SkaarjiI != None )
						{
						SkaarjiI.GotoState('Attacking');
						DeathMatchPlus(Level.Game).GiveWeapon(SkaarjiI,"BotPack.UT_Eightball");
						}
					}
				}
			PointCount++;
			}
		}
}

function SpawnMercs()
{
local NavigationPoint NP;
local Merc MercA;
local EliteMerc MercB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 50 )
					{
					MercA = Spawn(Class'Merc', , , NP.Location);
					if ( MercA != None )
						MercA.GotoState('Attacking');
					}
				else
					{
					MercB = Spawn(Class'EliteMerc', , , NP.Location);
					if ( MercB != None )
						MercB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnGassies()
{
local NavigationPoint NP;
local Gassie GassieA;
local EliteGassie GassieB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 50 )
					{
					GassieA = Spawn(Class'Gassie', , , NP.Location);
					if ( GassieA != None )
						GassieA.GotoState('Attacking');
					}
				else
					{
					GassieB = Spawn(Class'EliteGassie', , , NP.Location);
					if ( GassieB != None )
						GassieB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnManties()
{
local NavigationPoint NP;
local Manti MantiA;
local Manti MantiB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 50 )
					{
					MantiA = Spawn(Class'Manti', , , NP.Location);
					if ( MantiA != None )
						MantiA.GotoState('Attacking');
					}
				else
					{
					MantiB = Spawn(Class'Manti', , , NP.Location);
					if ( MantiB != None )
						MantiB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnBruties()
{
local NavigationPoint NP;
local Brutie BrutieA;
local Behemothie BrutieB;
local EliteBrutie BrutieC;
local ToxicBrutie BrutieD;
local RazorBrutie BrutieE;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 20 )
					{
					BrutieA = Spawn(Class'Brutie', , , NP.Location);
					if ( BrutieA != None )
						BrutieA.GotoState('Attacking');
					}
				else if ( Dice < 40 )
					{
					BrutieB = Spawn(Class'Behemothie', , , NP.Location);
					if ( BrutieB != None )
						BrutieB.GotoState('Attacking');
					}
				else if ( Dice < 60 )
					{
					BrutieC = Spawn(Class'EliteBrutie', , , NP.Location);
					if ( BrutieC != None )
						BrutieC.GotoState('Attacking');
					}
				else if ( Dice < 80 )
					{
					BrutieD = Spawn(Class'ToxicBrutie', , , NP.Location);
					if ( BrutieD != None )
						BrutieD.GotoState('Attacking');
					}
				else
					{
					BrutieE = Spawn(Class'RazorBrutie', , , NP.Location);
					if ( BrutieE != None )
						BrutieE.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnSnakes()
{
local NavigationPoint NP;
local Snake SnakeA, SnakeB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 100 )
					{
					SnakeA = Spawn(Class'Snake', , , NP.Location);
					if ( SnakeA != None )
						SnakeA.GotoState('Attacking');
					}
				else
					{
					SnakeB = Spawn(Class'Snake', , , NP.Location);
					if ( SnakeB != None )
						SnakeB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnFlyers()
{
local NavigationPoint NP;
local Flyer FlyerA, FlyerB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 100 )
					{
					FlyerA = Spawn(Class'Flyer', , , NP.Location);
					if ( FlyerA != None )
						FlyerA.GotoState('Attacking');
					}
				else
					{
					FlyerB = Spawn(Class'Flyer', , , NP.Location);
					if ( FlyerB != None )
						FlyerB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnPupies()
{
local NavigationPoint NP;
local Pupie PupieA;
local ElitePupie PupieB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 50 )
					{
					PupieA = Spawn(Class'Pupie', , , NP.Location);
					if ( PupieA != None )
						PupieA.GotoState('Attacking');
					}
				else
					{
					PupieB = Spawn(Class'ElitePupie', , , NP.Location);
					if ( PupieB != None )
						PupieB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnKralies()
{
local NavigationPoint NP;
local Krali KralieA;
local EliteKrali KralieB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 75 )
					{
					KralieA = Spawn(Class'Krali', , , NP.Location);
					if ( KralieA != None )
						KralieA.GotoState('Attacking');
					}
				else
					{
					KralieB = Spawn(Class'EliteKrali', , , NP.Location);
					if ( KralieB != None )
						KralieB.GotoState('Attacking');
					}
				return;
				}
			PointCount++;
			}
		}
}

defaultproperties
{
MaxMonsters=15
NumPoints=0
Delay=3
}